/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VWFilteredUsersAndGroupsPanel
extends VWFilteredUsersPanel
implements ActionListener {
    protected JRadioButton m_groupsRadioButton;
    protected JRadioButton m_usersRadioButton;

    public VWFilteredUsersAndGroupsPanel(Container parentContainer, VWSession vwSession) {
        super(parentContainer, vwSession);
    }

    public void removeReferences() {
        if (this.m_groupsRadioButton != null) {
            this.m_groupsRadioButton.removeActionListener(this);
            this.m_groupsRadioButton = null;
        }
        if (this.m_usersRadioButton != null) {
            this.m_usersRadioButton.removeActionListener(this);
            this.m_usersRadioButton = null;
        }
        super.removeReferences();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_groupsRadioButton)) {
                if (this.m_nType != 1 && this.m_itemFilterPanel != null) {
                    this.m_itemFilterPanel.clear();
                }
                this.m_nType = 1;
                this.updateAvailableList(null);
            } else if (event.getSource().equals(this.m_usersRadioButton)) {
                if (this.m_nType != 0 && this.m_itemFilterPanel != null) {
                    this.m_itemFilterPanel.clear();
                }
                this.m_nType = 0;
                this.updateAvailableList(null);
            } else if (event.getSource().equals(this.m_itemFilterPanel)) {
                switch (this.m_nType) {
                    case 0: {
                        this.updateAvailableList(this.m_itemFilterPanel.getUserParticipantItems());
                        break;
                    }
                    case 1: {
                        this.updateAvailableList(this.m_itemFilterPanel.getGroupParticipantItems());
                    }
                }
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
    }

    protected JPanel getHeaderPanel() {
        try {
            JPanel headerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 3, 0, 2);
            JLabel labelText = new JLabel(VWResource.s_showAvailableColon);
            VWAccessibilityHelper.setAccessibility(labelText, this, VWResource.s_showAvailableColon, VWResource.s_showAvailableColon);
            headerPanel.add((Component)labelText, gbCons);
            ButtonGroup filterGroup = new ButtonGroup();
            this.m_usersRadioButton = new JRadioButton(VWResource.s_Users);
            this.m_usersRadioButton.setSelected(true);
            this.m_usersRadioButton.addActionListener(this);
            this.m_usersRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setMemberOf(this.m_usersRadioButton, filterGroup);
            VWAccessibilityHelper.setAccessibility(this.m_usersRadioButton, headerPanel, VWResource.s_Users, VWResource.s_Users);
            this.m_groupsRadioButton = new JRadioButton(VWResource.s_Groups);
            this.m_groupsRadioButton.addActionListener(this);
            this.m_groupsRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setMemberOf(this.m_groupsRadioButton, filterGroup);
            VWAccessibilityHelper.setAccessibility(this.m_groupsRadioButton, headerPanel, VWResource.s_Groups, VWResource.s_Groups);
            filterGroup.add(this.m_usersRadioButton);
            filterGroup.add(this.m_groupsRadioButton);
            ++gbCons.gridx;
            gbCons.insets = new Insets(0, 3, 0, 0);
            headerPanel.add((Component)this.m_usersRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            headerPanel.add((Component)this.m_groupsRadioButton, gbCons);
            return headerPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

